<?php
	$show_tabs = false;
	if (get_option('resume_manager_enable_application')) {
		$show_tabs = true;
	}
	
	if (get_option('resume_manager_force_application')) {
		$show_tabs = false;
	}

if ($show_tabs) { ?><div id="tab1" class="tab-slider--body"><?php } ?>
	<?php global $post; ?>
	<form class="job-manager-application-form job-manager-form" method="post" enctype="multipart/form-data" action="<?php echo esc_url(get_permalink()); ?>">
		<?php do_action('job_application_form_fields_start'); ?>

		<?php foreach ($application_fields as $key => $field) : ?>
			<?php if ('output-content' === $field['type']) : ?>
				<div class="form-content">
					<h3><?php echo esc_html($field['label']); ?></h3>
					<?php if (!empty($field['description'])) : ?><?php echo wpautop(wp_kses_post($field['description'])); ?><?php endif; ?>
				</div>
			<?php else : ?>
				<fieldset class="fieldset-<?php echo esc_attr($key); ?>">
					<label for="<?php echo esc_attr($key); ?>"><?php $allowed_tags = wp_kses_allowed_html('post');
																echo wp_kses($field['label'], $allowed_tags);
																echo apply_filters('submit_job_form_required_label', $field['required'] ? '' : ' <small>' . esc_html__('(optional)', 'workscout') . '</small>', $field); ?></label>
					<div class="field <?php echo $field['required'] ? 'required-field' : ''; ?>">
						<?php $class->get_field_template($key, $field); ?>
					</div>
				</fieldset>
			<?php endif; ?>
		<?php endforeach; ?>

		<?php do_action('job_application_form_fields_end'); ?>

		<p class="send-app-btn">
			<input type="submit" name="wp_job_manager_send_application" value="<?php esc_attr_e('Send application', 'workscout'); ?>" />
			<input type="hidden" name="job_id" value="<?php echo absint($post->ID); ?>" />
		</p>
	</form>
	<?php if ($show_tabs) { ?></div><?php } ?>