<?php

/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WorkScout
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

	<?php wp_head(); ?>
</head>
<?php
$layout = Kirki::get_option('workscout', 'pp_body_style', 'fullwidth');
$sticky = Kirki::get_option('workscout', 'pp_sticky_header', 'fullwidth');
$fullwidth = Kirki::get_option('workscout', 'pp_fullwidth_header', false);
$job_page = get_option('job_manager_jobs_page_id');
$resume_page = get_option('resume_manager_resumes_page_id');

if ((!empty($job_page) && is_page($job_page)) || !empty($resume_page) && is_page($resume_page) || is_tax() || is_post_type_archive('job_listing')) {
	$layout = Kirki::get_option('workscout', 'jobs_list_layout');
	$resume_layout = Kirki::get_option('workscout', 'resumes_list_layout');
	if ($layout == 'split' || $layout == 'split_job_view' || $resume_layout == 'split') {
		$fullwidth = true;
	}
}

if ( is_post_type_archive('task') || is_tax('task_type') || is_tax('task_category') ) {
	$task_layout = get_option('task_list_layout'); 
	
	if ($task_layout == 'full' ) {
		$fullwidth = true;
	}
}
if (is_page_template('template-splitmap.php') || is_page_template('template-splitmap-resumes.php') || is_page_template('template-jobs-fullpage.php')|| is_page_template('template-resumes-fullpage.php') ||  is_page_template('template-tasks-fullpage.php')) {
	$fullwidth = true;
}
if(!is_user_logged_in() && is_page_template('template-dashboard.php')) {
	$sticky = false;
}
?>

<body <?php body_class($layout); ?>>
	<?php wp_body_open(); ?>
	<?php if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('header')) { ?>
		<?php


		if (is_singular()) {
			$transparent_header = get_post_meta($post->ID, 'pp_transparent_header', true);
			$header_image = get_post_meta($post->ID, 'pp_job_header_bg', TRUE);

			$header_image = get_post_meta($post->ID, 'pp_job_header_bg', TRUE);
			if (is_singular('job_listing')) {
				$transparent_header = false;
			}
			//   if(empty($header_image)) {
			//   	$transparent_header = false;
			//   }
		} else {
			$transparent_header = false;
		}

		?>
		<?php wp_body_open(); ?>
		<!-- Mobile Navigation -->
		<nav class="mobile-navigation-wrapper">
			<div class="mobile-nav-header">
				<div class="menu-logo">
					<?php
					$logo_transparent = Kirki::get_option('workscout', 'pp_transparent_logo_upload'); ?>
					<a href="<?php echo esc_url(home_url('/')); ?>" class="" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><img id="listeo_logo" src="<?php echo esc_url($logo_transparent); ?>" data-rjs="<?php echo esc_url($logo_transparent); ?>" alt="<?php esc_attr(bloginfo('name')); ?>" /></a>

				</div>
				<a href="#" class="menu-icon-toggle"></a>
			</div>

			<div class="mobile-navigation-list">
				<?php
				if (has_nav_menu('mobile')) {
					$menu_location = 'mobile';
				} else {
					$menu_location = 'primary';
				}
				wp_nav_menu(array(
					'theme_location' => $menu_location,
					'menu_id' => 'mobile-nav',
					'container' => false,
				));  ?>
			</div>

			<div class="mobile-nav-widgets">
				<?php dynamic_sidebar('mobilemenu'); ?>
			</div>
		</nav>
		<!-- Mobile Navigation / End-->
		<div id="wrapper" class="fullwidth new-header <?php if ($transparent_header) : ?> wrapper-with-transparent-header <?php endif; ?>">

			<header id="header-container" class="<?php if ($fullwidth) : echo "fullwidth ";
													endif;
													if ($sticky) : echo "sticky_new ";
													endif;
													if ($transparent_header) : ?>transparent-header<?php endif; ?>">
				<!-- Header -->
				<div id="header">
					<div class="container">

						<!-- Left Side Content -->
						<div class="left-side">
							<div id="logo_nh">
								<?php

								$logo = Kirki::get_option('workscout', 'pp_logo_upload', '');
								$logo_retina = Kirki::get_option('workscout', 'pp_retina_logo_upload', '');
								if (is_singular()) {

									$header_image = get_post_meta($post->ID, 'pp_job_header_bg', TRUE);
									$transparent_status = get_post_meta($post->ID, 'pp_transparent_header', TRUE);



									if ($transparent_status == 'on') {

										$logo_transparent = Kirki::get_option('workscout', 'pp_transparent_logo_upload');
										$logo_retina = Kirki::get_option('workscout', 'pp_transparent_retina_logo_upload', '');
										$logo = (!empty($logo_transparent)) ? $logo_transparent : $logo;
									}
								}



								if ($logo) {
									if (is_front_page()) { ?>
										<a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><img src="<?php echo esc_url($logo); ?>" data-rjs="<?php echo esc_url($logo_retina); ?>" alt="<?php esc_attr(bloginfo('name')); ?>" /></a>
									<?php } else { ?>
										<a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><img src="<?php echo esc_url($logo); ?>" data-rjs="<?php echo esc_url($logo_retina); ?>" alt="<?php esc_attr(bloginfo('name')); ?>" /></a>
									<?php }
								} else {
									if (is_front_page()) { ?>
										<h1><a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
									<?php } else { ?>
										<h2><a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><?php bloginfo('name'); ?></a></h2>
								<?php }
								}
								?>
								<?php if (get_theme_mod('workscout_tagline_switch', 'hide') == 'show') { ?><div id="blogdesc"><?php bloginfo('description'); ?></div><?php } ?>
							</div>
							<!-- eof logo -->

							<!-- menu -->

							<nav id="navigation" class="menu">
								<?php wp_nav_menu(array('theme_location' => 'primary', 'menu_id' => 'responsive', 'container' => false)); ?>
							</nav>
							<div class="clearfix"></div>
							<!-- Main Navigation / End -->

						</div>
						<!-- Left Side Content / End -->

						<!-- Right Side Content / End -->
						<div class="right-side">

							<!-- Header Widget -->
							<div class="header-widget">
								<?php
								$my_account_display = Kirki::get_option('workscout', 'pp_login_form_status', true);

								if (is_user_logged_in()) {
									if (class_exists('WorkScout_Core_Template_Loader')) :
										$template_loader = new WorkScout_Core_Template_Loader;
										$template_loader->get_template_part('account/logged_section');
									endif;
								} else {

									$popup_login = get_option('workscout_popup_login');

								?>
									<div class="login-register-buttons">
										<?php
										if ($my_account_display && function_exists('WorkScout_Core')) :

											if ($popup_login == 'ajax' && !is_page_template('template-dashboard.php')) { ?>

												<a href="#login-dialog" class="small-dialog popup-with-zoom-anim login-btn"><i class="la la-sign-in-alt"></i> <?php esc_html_e('Log In', 'workscout'); ?></a>
												<a href="#signup-dialog" class="small-dialog popup-with-zoom-anim register-btn"><i class="la la-plus-circle"></i> <?php esc_html_e('Register', 'workscout'); ?></a>

											<?php } else {
												$login_page = get_option('workscout_profile_page'); ?>
												<a href="<?php echo esc_url(get_permalink($login_page)); ?>" class="login-btn"><i class="la la-sign-in-alt"></i> <?php esc_html_e('Log In', 'workscout'); ?></a>
												<a href="<?php echo esc_url(get_permalink($login_page)); ?>#tab2" class="register-btn"><i class="la la-plus-circle"></i> <?php esc_html_e('Register', 'workscout'); ?></a>
										<?php }

										endif; ?>
									</div>


								<?php } ?>

							</div>
							<!-- Header Widget / End -->

							<!-- Mobile Navigation Button -->
							<span class="mmenu-trigger">
								<button class="hamburger hamburger--collapse" type="button">
									<span class="hamburger-box">
										<span class="hamburger-inner"></span>
									</span>
								</button>
							</span>

						</div>
						<!-- Right Side Content / End -->

					</div>
				</div>
				<!-- Header / End -->

			</header>
			<div class="clearfix"></div>
			<!-- Header Container / End -->

		<?php } else { ?>
			<div id="wrapper">


			<?php }
	$my_account_display = Kirki::get_option('workscout', 'pp_login_form_status', true);
		if (true == $my_account_display && !is_page_template('template-dashboard.php')) : ?>
				<!-- Sign In Popup -->
				<div id="login-dialog" class="small-dialog apply-popup zoom-anim-dialog mfp-hide workscout-signup-popup">

					<div class="small-dialog-headline">
						<h2><?php esc_html_e('Log In', 'workscout'); ?></h2>
					</div>
					<!--Tabs -->
					<div class="small-dialog-content">
						<?php do_action('workscout_login_form'); ?>
					</div>
				</div>


				<div id="signup-dialog" class="small-dialog apply-popup zoom-anim-dialog mfp-hide  workscout-signup-popup">

					<div class="small-dialog-headline">
						<h2><?php esc_html_e('Sign Up', 'workscout'); ?></h2>
					</div>
					<!--Tabs -->

					<div class="small-dialog-content">
						<?php do_action('workscout_registration_form'); ?>
					</div>
				</div>
				<!-- Sign In Popup / End -->
			<?php endif; ?>
			<div class="clearfix"></div>
			<!-- Header Container / End -->